<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve input data from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Extract input data
$id = $data['id'] ?? null;
$name = $data['name'] ?? null;
$email = $data['email'] ?? null;
$phone = $data['phone'] ?? null;
$subject = $data['subject'] ?? null;
$message = $data['message'] ?? null;
$product_id = $data['product_id'] ?? null;

// Validate required fields
if (!$id || !$name || !$email || !$phone || !$subject || !$message || !$product_id) {
    echo json_encode(["status" => "error", "message" => "ID, Name, Email, Phone, Subject, Message, and Product ID are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$id = intval($id);
$name = mysqli_real_escape_string($conn, $name);
$email = mysqli_real_escape_string($conn, $email);
$phone = mysqli_real_escape_string($conn, $phone);
$subject = mysqli_real_escape_string($conn, $subject);
$message = mysqli_real_escape_string($conn, $message);
$product_id = intval($product_id);

// Update query to modify the existing entry in the enquiry_form table
$query = "UPDATE enquiry_form 
          SET name = '$name', email = '$email', phone = '$phone', subject = '$subject', 
              message = '$message', product_id = $product_id 
          WHERE id = $id";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "Enquiry form updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update enquiry form"]);
}
?>
